<?php
/**
 * Header template.
 *
 * @package Avada
 * @subpackage Templates
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<!DOCTYPE html>
<html class="<?php avada_the_html_class(); ?>" <?php language_attributes(); ?>>
<head>
	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-5BHQNJZ');</script>
<!-- End Google Tag Manager -->
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?php Avada()->head->the_viewport(); ?>

	<?php wp_head(); ?>

	<?php $object_id = get_queried_object_id(); ?>
	<?php $c_page_id = Avada()->fusion_library->get_page_id(); ?>

	<script type="text/javascript">
		var doc = document.documentElement;
		doc.setAttribute('data-useragent', navigator.userAgent);
	</script>

	<?php
	/**
	 *
	 * The settings below are not sanitized.
	 * In order to be able to take advantage of this,
	 * a user would have to gain access to the database
	 * in which case this is the least on your worries.
	 */
	echo apply_filters( 'avada_google_analytics', Avada()->settings->get( 'google_analytics' ) ); // WPCS: XSS ok.
	echo apply_filters( 'avada_space_head', Avada()->settings->get( 'space_head' ) ); // WPCS: XSS ok.
	?>
<script type="application/ld+json">
{
	"@context": "http://schema.org",
	"@type": "AutomotiveBusiness",
	"name": "Werribee Automotive",
	"url": "https://www.werribeeautomotive.com.au/",
	"logo": "https://www.werribeeautomotive.com.au/wp-content/uploads/2017/08/logo-1.png",
"description": "Since 15 years, we are actively operated as a Werribee Automotive which is our family hold business along with the help of our expert and 

specialist team. Without them we couldn’t take pride for brilliance service provided by us.",
	"founder": {
		"@type": "Person",
		"name": "Calvin Moor",
		"email": "mailto:werribeeauto@gmail.com",
		"image": "https://www.werribeeautomotive.com.au/wp-content/uploads/2017/08/logo-1.png"
	},
	"address": {
		"@type": "PostalAddress",
		"streetAddress": "1/61-65 Russell Street",
		"addressLocality": "Werribee  , VIC , Australia",
		"postalCode": "3030"
	},
	"email": "werribeeauto@gmail.com",
	"telephone": "+61  (03) 9741 6211",
	"openingHours": " Mon - Fir 7:30 AM - 5:30 PM Sat 8AM - 1PM",
	"paymentAccepted": "Cash, Cards, Checks",
	"geo": {
		"@type": "GeoCoordinates",    
		"latitude": "-37.8947834", 
		"longitude": "144.6644783"
	},
	"aggregateRating": {
			"@type": "AggregateRating",
		"ratingValue": "4.5",
		"reviewCount": "12"
	},
	"image": {
		"@type": "ImageObject",
		"url": "https://www.werribeeautomotive.com.au/wp-content/uploads/2017/08/logo-1.png"
	},
	"sameAs": "https://www.facebook.com/werribeeautomotive"
}
</script>
	
</head>

<?php
$wrapper_class = ( is_page_template( 'blank.php' ) ) ? 'wrapper_blank' : '';

if ( 'modern' === Avada()->settings->get( 'mobile_menu_design' ) ) {
	$mobile_logo_pos = strtolower( Avada()->settings->get( 'logo_alignment' ) );
	if ( 'center' === strtolower( Avada()->settings->get( 'logo_alignment' ) ) ) {
		$mobile_logo_pos = 'left';
	}
}

?>
<body <?php body_class(); ?>>
	<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5BHQNJZ"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'Avada' ); ?></a>
	<?php
	do_action( 'avada_before_body_content' );

	$boxed_side_header_right = false;
	$page_bg_layout = 'default';
	if ( $c_page_id && is_numeric( $c_page_id ) ) {
		$fpo_page_bg_layout = get_post_meta( $c_page_id, 'pyre_page_bg_layout', true );
		$page_bg_layout = ( $fpo_page_bg_layout ) ? $fpo_page_bg_layout : $page_bg_layout;
	}

	?>
	<?php if ( ( ( 'Boxed' === Avada()->settings->get( 'layout' ) && ( 'default' === $page_bg_layout || '' == $page_bg_layout ) ) || 'boxed' === $page_bg_layout ) && 'Top' != Avada()->settings->get( 'header_position' ) ) : ?>
		<div id="boxed-wrapper">
	<?php endif; ?>
	<?php if ( ( ( 'Boxed' === Avada()->settings->get( 'layout' ) && 'default' === $page_bg_layout ) || 'boxed' === $page_bg_layout ) && 'framed' === Avada()->settings->get( 'scroll_offset' ) ) : ?>
		<div class="fusion-sides-frame"></div>
	<?php endif; ?>
	<div id="wrapper" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<div id="home" style="position:relative;top:-1px;"></div>
		<?php avada_header_template( 'Below', ( is_archive() || Avada_Helper::bbp_is_topic_tag() ) && ! ( class_exists( 'WooCommerce' ) && is_shop() ) ); ?>
		<?php if ( 'Left' === Avada()->settings->get( 'header_position' ) || 'Right' === Avada()->settings->get( 'header_position' ) ) : ?>
			<?php avada_side_header(); ?>
		<?php endif; ?>

		<?php avada_sliders_container(); ?>

		<?php avada_header_template( 'Above', ( is_archive() || Avada_Helper::bbp_is_topic_tag() ) && ! ( class_exists( 'WooCommerce' ) && is_shop() ) ); ?>

		<?php if ( has_action( 'avada_override_current_page_title_bar' ) ) : ?>
			<?php do_action( 'avada_override_current_page_title_bar', $c_page_id ); ?>
		<?php else : ?>
			<?php avada_current_page_title_bar( $c_page_id ); ?>
		<?php endif; ?>

		<?php if ( is_page_template( 'contact.php' ) && Avada()->settings->get( 'recaptcha_public' ) && Avada()->settings->get( 'recaptcha_private' ) ) : ?>
			<script type="text/javascript">var RecaptchaOptions = { theme : '<?php echo esc_attr( Avada()->settings->get( 'recaptcha_color_scheme' ) ); ?>' };</script>
		<?php endif; ?>

		<?php if ( is_page_template( 'contact.php' ) && Avada()->settings->get( 'gmap_address' ) && Avada()->settings->get( 'status_gmap' ) ) : ?>
			<?php
			$map_popup             = ( ! Avada()->settings->get( 'map_popup' ) ) ? 'yes' : 'no';
			$map_scrollwheel       = ( Avada()->settings->get( 'map_scrollwheel' ) ) ? 'yes' : 'no';
			$map_scale             = ( Avada()->settings->get( 'map_scale' ) ) ? 'yes' : 'no';
			$map_zoomcontrol       = ( Avada()->settings->get( 'map_zoomcontrol' ) ) ? 'yes' : 'no';
			$address_pin           = ( Avada()->settings->get( 'map_pin' ) ) ? 'yes' : 'no';
			$address_pin_animation = ( Avada()->settings->get( 'gmap_pin_animation' ) ) ? 'yes' : 'no';
			?>
			<div id="fusion-gmap-container">
				<?php
				echo Avada()->google_map->render_map( // WPCS: XSS ok.
					array(
						'api_type'                 => esc_html( Avada()->settings->get( 'gmap_api_type' ) ),
						'embed_address'            => esc_html( Avada()->settings->get( 'gmap_embed_address' ) ),
						'embed_map_type'           => esc_html( Avada()->settings->get( 'gmap_embed_map_type' ) ),
						'address'                  => esc_html( Avada()->settings->get( 'gmap_address' ) ),
						'type'                     => esc_attr( Avada()->settings->get( 'gmap_type' ) ),
						'address_pin'              => esc_attr( $address_pin ),
						'animation'                => esc_attr( $address_pin_animation ),
						'map_style'                => esc_attr( Avada()->settings->get( 'map_styling' ) ),
						'overlay_color'            => esc_attr( Avada()->settings->get( 'map_overlay_color' ) ),
						'infobox'                  => esc_attr( Avada()->settings->get( 'map_infobox_styling' ) ),
						'infobox_background_color' => esc_attr( Avada()->settings->get( 'map_infobox_bg_color' ) ),
						'infobox_text_color'       => esc_attr( Avada()->settings->get( 'map_infobox_text_color' ) ),
						'infobox_content'          => htmlentities( Avada()->settings->get( 'map_infobox_content' ) ),
						'icon'                     => esc_attr( Avada()->settings->get( 'map_custom_marker_icon' ) ),
						'width'                    => esc_attr( Avada()->settings->get( 'gmap_dimensions', 'width' ) ),
						'height'                   => esc_attr( Avada()->settings->get( 'gmap_dimensions', 'height' ) ),
						'zoom'                     => esc_attr( Avada()->settings->get( 'map_zoom_level' ) ),
						'scrollwheel'              => esc_attr( $map_scrollwheel ),
						'scale'                    => esc_attr( $map_scale ),
						'zoom_pancontrol'          => esc_attr( $map_zoomcontrol ),
						'popup'                    => esc_attr( $map_popup ),
					)
				);
				?>
			</div>
		<?php endif; ?>
		<?php
		$main_css   = '';
		$row_css    = '';
		$main_class = '';

		if ( apply_filters( 'fusion_is_hundred_percent_template', false, $c_page_id ) ) {
			$main_css = 'padding-left:0px;padding-right:0px;';
			$hundredp_padding = get_post_meta( $c_page_id, 'pyre_hundredp_padding', true );
			if ( Avada()->settings->get( 'hundredp_padding' ) && ! $hundredp_padding ) {
				$main_css = 'padding-left:' . Avada()->settings->get( 'hundredp_padding' ) . ';padding-right:' . Avada()->settings->get( 'hundredp_padding' );
			}
			if ( $hundredp_padding ) {
				$main_css = 'padding-left:' . $hundredp_padding . ';padding-right:' . $hundredp_padding;
			}
			$row_css    = 'max-width:100%;';
			$main_class = 'width-100';
		}
		do_action( 'avada_before_main_container' );
		?>
		<main id="main" role="main" class="clearfix <?php echo esc_attr( $main_class ); ?>" style="<?php echo esc_attr( $main_css ); ?>">
			<div class="fusion-row" style="<?php echo esc_attr( $row_css ); ?>">
